"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.RRWEB_VERSION = exports.DIST_METHOD = exports.BUILD_ENV = void 0;
var _package = _interopRequireDefault(require("../../../package.json"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * @file This file exposes build time environment variables that will be included in the
 * build output of the agent. This file specifically contains the normal environment variables
 * for the NPM agent build and will be overridden by webpack/babel during the build based on the
 * type of build being performed.
 */

/**
 * Exposes the version of the agent
 */
const VERSION = exports.VERSION = _package.default.version;

/**
 * Exposes the build type of the agent
 */
const BUILD_ENV = exports.BUILD_ENV = 'NPM';

/**
 * Exposes the distribution method of the agent
 */
const DIST_METHOD = exports.DIST_METHOD = 'NPM';

/**
 * Exposes the lib version of rrweb
 */
const RRWEB_VERSION = exports.RRWEB_VERSION = _package.default.dependencies.rrweb;