"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.supportsSendBeacon = exports.offset = exports.loadedAsDeferredBrowserScript = exports.isiOS = exports.isWorkerScope = exports.isIE = exports.isBrowserScope = exports.initiallyHidden = exports.initialLocation = exports.iOSBelow16 = exports.globalScope = exports.ffVersion = void 0;
/**
 * @file Contains constants about the environment the agent is running
 * within. These values are derived at the time the agent is first loaded.
 * @copyright 2023 New Relic Corporation. All rights reserved.
 * @license Apache-2.0
 */

/**
 * Indicates if the agent is running within a normal browser window context.
 */
const isBrowserScope = exports.isBrowserScope = typeof window !== 'undefined' && !!window.document;

/**
 * Indicates if the agent is running within a worker context.
 */
const isWorkerScope = exports.isWorkerScope = typeof WorkerGlobalScope !== 'undefined' && (typeof self !== 'undefined' && self instanceof WorkerGlobalScope && self.navigator instanceof WorkerNavigator || typeof globalThis !== 'undefined' && globalThis instanceof WorkerGlobalScope && globalThis.navigator instanceof WorkerNavigator);
const globalScope = exports.globalScope = isBrowserScope ? window : typeof WorkerGlobalScope !== 'undefined' && (typeof self !== 'undefined' && self instanceof WorkerGlobalScope && self || typeof globalThis !== 'undefined' && globalThis instanceof WorkerGlobalScope && globalThis);
const loadedAsDeferredBrowserScript = exports.loadedAsDeferredBrowserScript = globalScope?.document?.readyState === 'complete';
const initiallyHidden = exports.initiallyHidden = Boolean(globalScope?.document?.visibilityState === 'hidden');
const initialLocation = exports.initialLocation = '' + globalScope?.location;
const isiOS = exports.isiOS = /iPad|iPhone|iPod/.test(globalScope.navigator?.userAgent);

/**
 * Shared Web Workers introduced in iOS 16.0+ and n/a in 15.6-
 *
 * It was discovered in Safari 14 (https://bugs.webkit.org/show_bug.cgi?id=225305) that the buffered flag in PerformanceObserver
 * did not work. This affects our onFCP metric in particular since web-vitals uses that flag to retrieve paint timing entries.
 * This was fixed in v16+.
 */
const iOSBelow16 = exports.iOSBelow16 = isiOS && typeof SharedWorker === 'undefined';
const ffVersion = exports.ffVersion = (() => {
  const match = globalScope.navigator?.userAgent?.match(/Firefox[/\s](\d+\.\d+)/);
  if (Array.isArray(match) && match.length >= 2) {
    return +match[1];
  }
  return 0;
})();
const isIE = exports.isIE = Boolean(isBrowserScope && window.document.documentMode); // deprecated property that only works in IE

const supportsSendBeacon = exports.supportsSendBeacon = !!globalScope.navigator?.sendBeacon;
const offset = exports.offset = Math.floor(globalScope?.performance?.timeOrigin || globalScope?.performance?.timing?.navigationStart || Date.now());