"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sharedChannel = void 0;
/**
 * @file Keeps an object alive that is passed to all feature aggregate modules.
 * The purpose is to have a way for communication and signals to relay across features at runtime.
 * This object can hold any arbitrary values and should be treated as on-the-fly dynamic.
 */

let onReplayReady;
const sessionReplayInitialized = new Promise(resolve => {
  onReplayReady = resolve;
});
const sharedChannel = exports.sharedChannel = Object.freeze({
  onReplayReady,
  sessionReplayInitialized
});