"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharedContext = void 0;
var _console = require("../util/console");
const model = {
  agentIdentifier: '',
  ee: undefined
};
class SharedContext {
  constructor(context) {
    try {
      if (typeof context !== 'object') return (0, _console.warn)('shared context requires an object as input');
      this.sharedContext = {};
      Object.assign(this.sharedContext, model);
      Object.entries(context).forEach(_ref => {
        let [key, value] = _ref;
        if (Object.keys(model).includes(key)) this.sharedContext[key] = value;
      });
    } catch (err) {
      (0, _console.warn)('An error occured while setting SharedContext', err);
    }
  }
}
exports.SharedContext = SharedContext;