"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRegister = exports.registerHandler = defaultRegister;
var _handle = require("./handle");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

defaultRegister.on = registerWithSpecificEmitter;
var handlers = defaultRegister.handlers = {};
function defaultRegister(type, handler, group, ee) {
  registerWithSpecificEmitter(ee || _handle.handleEE, handlers, type, handler, group);
}
function registerWithSpecificEmitter(ee, handlers, type, handler, group) {
  if (!group) group = 'feature';
  if (!ee) ee = _handle.handleEE;
  var groupHandlers = handlers[group] = handlers[group] || {};
  var list = groupHandlers[type] = groupHandlers[type] || [];
  list.push([ee, handler]);
}