"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.id = id;
var _getOrSet = require("../util/get-or-set");
var _runtime = require("../constants/runtime");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

// Start assigning ids at 1 so 0 can always be used for Window or WorkerGlobalScope, without
// actually setting it (which would create a global variable).
let index = 1;
const prop = 'nr@id';

/**
 * Tags a specified object with an identifier if it does not already
 * have one. If the object is the global scope, zero will be returned
 * and the object will not be modified. If the object already contains
 * an identifier, it will be returned without modification. If the passed
 * value is not an object, function, or array, -1 will be returned without
 * modifying the passed value.
 * @param {object|function|array} obj Object to be tagged with an identifier
 * @returns {number} Identifier of the given object
 */
function id(obj) {
  const type = typeof obj;
  // We can only tag objects, functions, and arrays with ids.
  // For all primitive values we instead return -1.
  if (!obj || !(type === 'object' || type === 'function')) return -1;
  if (obj === _runtime.globalScope) return 0;
  return (0, _getOrSet.getOrSet)(obj, prop, function () {
    return index++;
  });
}