"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canonicalizeUrl = canonicalizeUrl;
var _runtime = require("../constants/runtime");
var _cleanUrl = require("./clean-url");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Converts a URL to its basic form without a query string or fragment. If the resulting URL is the same as the
 * loader's origin URL, returns '<inline>'.
 * @param {string} url - The URL to be canonicalized.
 * @param {string} loaderOriginUrl - The origin URL of the agent loader, used for inline detection.
 * @returns {string} The canonicalized URL, or '<inline>' if the URL matches the loader origin URL.
 */
function canonicalizeUrl(url) {
  if (typeof url !== 'string') return '';
  const cleanedUrl = (0, _cleanUrl.cleanURL)(url);
  const cleanedGlobalScopeUrl = (0, _cleanUrl.cleanURL)(_runtime.initialLocation);

  // If the URL matches the origin URL of the loader, we assume it originated within an inline script.
  if (cleanedUrl === cleanedGlobalScopeUrl) {
    return '<inline>';
  } else {
    return cleanedUrl;
  }
}