"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanURL = cleanURL;
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

var patternWithHash = /([^?#]*)[^#]*(#[^?]*|$).*/;
var patternWithoutHash = /([^?#]*)().*/;

/**
 * Cleans a URL by removing the query string and fragment (hash portion).
 * @param {string} url - The original URL to be cleaned.
 * @param {boolean} [keepHash=false] - Whether to preserve the hash portion of the URL.
 * @returns {string} The cleaned URL.
 */
function cleanURL(url, keepHash) {
  return url.replace(keepHash ? patternWithHash : patternWithoutHash, '$1$2');
}