"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromArray = fromArray;
exports.obj = obj;
exports.param = param;
exports.qs = qs;
var _mapOwn = require("../util/map-own");
var _stringify = require("../util/stringify");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

// Characters that are safe in a qs, but get encoded.
var charMap = {
  '%2C': ',',
  '%3A': ':',
  '%2F': '/',
  '%40': '@',
  '%24': '$',
  '%3B': ';'
};
var charList = (0, _mapOwn.mapOwn)(charMap, function (k) {
  return k;
});
var safeEncoded = new RegExp(charList.join('|'), 'g');
function real(c) {
  return charMap[c];
}

// Encode as URI Component, then unescape anything that is ok in the
// query string position.
function qs(value) {
  if (value === null || value === undefined) return 'null';
  return encodeURIComponent(value).replace(safeEncoded, real);
}
function fromArray(qs, maxBytes) {
  var bytes = 0;
  for (var i = 0; i < qs.length; i++) {
    bytes += qs[i].length;
    if (bytes > maxBytes) return qs.slice(0, i).join('');
  }
  return qs.join('');
}
function obj(payload, maxBytes) {
  var total = 0;
  var result = '';
  (0, _mapOwn.mapOwn)(payload, function (feature, dataArray) {
    var intermediate = [];
    var next;
    var i;
    if (typeof dataArray === 'string' || !Array.isArray(dataArray) && dataArray !== null && dataArray !== undefined && dataArray.toString().length) {
      next = '&' + feature + '=' + qs(dataArray);
      total += next.length;
      result += next;
    } else if (Array.isArray(dataArray) && dataArray.length) {
      total += 9;
      for (i = 0; i < dataArray.length; i++) {
        next = qs((0, _stringify.stringify)(dataArray[i]));
        total += next.length;
        if (typeof maxBytes !== 'undefined' && total >= maxBytes) break;
        intermediate.push(next);
      }
      result += '&' + feature + '=%5B' + intermediate.join(',') + '%5D';
    }
  });
  return result;
}

// Constructs an HTTP parameter to add to the BAM router URL
function param(name, value) {
  let base = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (Object.keys(base).includes(name)) return ''; // we assume if feature supplied a matching qp to the base, we should honor what the feature sent over the default
  if (value && typeof value === 'string') {
    return '&' + name + '=' + qs(value);
  }
  return '';
}