"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.warn = warn;
/**
 * A helper method to warn to the console with New Relic: decoration
 * @param {string} message The primary message to warn
 * @param {*} [secondary] Secondary data to include, usually an error or object
 * @returns
 */
function warn(message, secondary) {
  if (typeof console.warn !== 'function') return;
  console.warn("New Relic: ".concat(message));
  if (secondary) console.warn(secondary);
}