"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataSize = dataSize;
var _stringify = require("./stringify");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Returns the size of the provided data. Designed for measuring XHR responses.
 *
 * @param {*} data - The data to be measured.
 * @returns {(number|undefined)} - The size of the data or undefined if size cannot be determined.
 */
function dataSize(data) {
  if (typeof data === 'string' && data.length) return data.length;
  if (typeof data !== 'object') return undefined;
  // eslint-disable-next-line
  if (typeof ArrayBuffer !== 'undefined' && data instanceof ArrayBuffer && data.byteLength) return data.byteLength;
  if (typeof Blob !== 'undefined' && data instanceof Blob && data.size) return data.size;
  if (typeof FormData !== 'undefined' && data instanceof FormData) return undefined;
  try {
    return (0, _stringify.stringify)(data).length;
  } catch (e) {
    return undefined;
  }
}