"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.activateFeatures = activateFeatures;
exports.activatedFeatures = void 0;
var _contextualEe = require("../event-emitter/contextual-ee");
var _globalEvent = require("../dispatch/global-event");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

const sentIds = new Set();

/** A map of feature flags and their values as provided by the rum call -- scoped by agent ID */
const activatedFeatures = exports.activatedFeatures = {};

/**
 * Sets the activatedFeatures object, dispatches the global loaded event,
 * and emits the rumresp flag to features
 * @param {{[key:string]:number}} flags key-val pair of flag names and numeric
 * @param {string} agentIdentifier agent instance identifier
 * @returns {void}
 */
function activateFeatures(flags, agentIdentifier) {
  const sharedEE = _contextualEe.ee.get(agentIdentifier);
  activatedFeatures[agentIdentifier] ??= {};
  if (!(flags && typeof flags === 'object')) return;
  if (sentIds.has(agentIdentifier)) return;
  sharedEE.emit('rumresp', [flags]);
  activatedFeatures[agentIdentifier] = flags;
  sentIds.add(agentIdentifier);

  // let any window level subscribers know that the agent is running
  (0, _globalEvent.dispatchGlobalEvent)({
    loaded: true
  });
}