"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cumulativeLayoutShift = void 0;
var _webVitals = require("web-vitals");
var _constants = require("./constants");
var _vitalMetric = require("./vital-metric");
var _runtime = require("../constants/runtime");
const cumulativeLayoutShift = exports.cumulativeLayoutShift = new _vitalMetric.VitalMetric(_constants.VITAL_NAMES.CUMULATIVE_LAYOUT_SHIFT, x => x);
if (_runtime.isBrowserScope) {
  (0, _webVitals.onCLS)(_ref => {
    let {
      value,
      entries
    } = _ref;
    if (cumulativeLayoutShift.roundingMethod(value) === cumulativeLayoutShift.current.value) return;
    cumulativeLayoutShift.update({
      value,
      entries
    });
  }, {
    reportAllChanges: true
  });
}