"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firstContentfulPaint = void 0;
var _webVitals = require("web-vitals");
var _runtime = require("../constants/runtime");
var _constants = require("./constants");
var _vitalMetric = require("./vital-metric");
// eslint-disable-next-line camelcase

const firstContentfulPaint = exports.firstContentfulPaint = new _vitalMetric.VitalMetric(_constants.VITAL_NAMES.FIRST_CONTENTFUL_PAINT);

/* First Contentful Paint - As of WV v3, it still imperfectly tries to detect document vis state asap and isn't supposed to report if page starts hidden. */
if (_runtime.isBrowserScope) {
  // eslint-disable-next-line camelcase
  if (_runtime.iOSBelow16) {
    try {
      if (!_runtime.initiallyHidden) {
        // see ios-version.js for detail on this following bug case; tldr: buffered flag doesn't work but getEntriesByType does
        const paintEntries = performance.getEntriesByType('paint');
        paintEntries.forEach(entry => {
          if (entry.name === 'first-contentful-paint') {
            firstContentfulPaint.update({
              value: Math.floor(entry.startTime),
              entries: paintEntries
            });
          }
        });
      }
    } catch (e) {
      // ignore
    }
  } else {
    (0, _webVitals.onFCP)(_ref => {
      let {
        value,
        entries
      } = _ref;
      if (_runtime.initiallyHidden || firstContentfulPaint.isValid) return;
      firstContentfulPaint.update({
        value,
        entries
      });
    });
  }
}