"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firstInputDelay = void 0;
var _webVitals = require("web-vitals");
var _vitalMetric = require("./vital-metric");
var _constants = require("./constants");
var _runtime = require("../constants/runtime");
const firstInputDelay = exports.firstInputDelay = new _vitalMetric.VitalMetric(_constants.VITAL_NAMES.FIRST_INPUT_DELAY);
if (_runtime.isBrowserScope) {
  (0, _webVitals.onFID)(_ref => {
    let {
      value,
      entries
    } = _ref;
    if (_runtime.initiallyHidden || firstInputDelay.isValid || entries.length === 0) return;

    // CWV will only report one (THE) first-input entry to us; fid isn't reported if there are no user interactions occurs before the *first* page hiding.
    firstInputDelay.update({
      value: entries[0].startTime,
      entries,
      attrs: {
        type: entries[0].name,
        fid: Math.round(value)
      }
    });
  });
}