"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.firstPaint = void 0;
var _runtime = require("../constants/runtime");
var _constants = require("./constants");
var _vitalMetric = require("./vital-metric");
const firstPaint = exports.firstPaint = new _vitalMetric.VitalMetric(_constants.VITAL_NAMES.FIRST_PAINT);
if (_runtime.isBrowserScope) {
  const handleEntries = entries => {
    entries.forEach(entry => {
      if (entry.name === 'first-paint' && !firstPaint.isValid) {
        observer.disconnect();

        /* Initial hidden state and pre-rendering not yet considered for first paint. See web-vitals onFCP for example. */
        firstPaint.update({
          value: entry.startTime,
          entries
        });
      }
    });
  };
  let observer;
  try {
    if (PerformanceObserver.supportedEntryTypes.includes('paint') && !_runtime.initiallyHidden) {
      observer = new PerformanceObserver(list => {
        // Delay by a microtask to workaround a bug in Safari where the
        // callback is invoked immediately, rather than in a separate task.
        // See: https://github.com/GoogleChrome/web-vitals/issues/277
        Promise.resolve().then(() => {
          handleEntries(list.getEntries());
        });
      });
      observer.observe({
        type: 'paint',
        buffered: true
      });
    }
  } catch (e) {
    // Do nothing.
  }
}