"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.largestContentfulPaint = void 0;
var _webVitals = require("web-vitals");
var _vitalMetric = require("./vital-metric");
var _constants = require("./constants");
var _runtime = require("../constants/runtime");
var _cleanUrl = require("../url/clean-url");
const largestContentfulPaint = exports.largestContentfulPaint = new _vitalMetric.VitalMetric(_constants.VITAL_NAMES.LARGEST_CONTENTFUL_PAINT);
if (_runtime.isBrowserScope) {
  (0, _webVitals.onLCP)(_ref => {
    let {
      value,
      entries
    } = _ref;
    /* Largest Contentful Paint - As of WV v3, it still imperfectly tries to detect document vis state asap and isn't supposed to report if page starts hidden. */
    if (_runtime.initiallyHidden || largestContentfulPaint.isValid) return;
    const lcpEntry = entries[entries.length - 1]; // this looks weird if we only expect one, but this is how cwv-attribution gets it so to be sure...
    largestContentfulPaint.update({
      value,
      entries,
      ...(entries.length > 0 && {
        attrs: {
          size: lcpEntry.size,
          eid: lcpEntry.id,
          ...(!!lcpEntry.url && {
            elUrl: (0, _cleanUrl.cleanURL)(lcpEntry.url)
          }),
          ...(!!lcpEntry.element?.tagName && {
            elTag: lcpEntry.element.tagName
          })
        }
      })
    });
  });
}