"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeToFirstByte = void 0;
var _runtime = require("../constants/runtime");
var _constants = require("./constants");
var _vitalMetric = require("./vital-metric");
var _webVitals = require("web-vitals");
const timeToFirstByte = exports.timeToFirstByte = new _vitalMetric.VitalMetric(_constants.VITAL_NAMES.TIME_TO_FIRST_BYTE);
if (_runtime.isBrowserScope && typeof PerformanceNavigationTiming !== 'undefined' && !_runtime.isiOS) {
  (0, _webVitals.onTTFB)(_ref => {
    let {
      value,
      entries
    } = _ref;
    if (!timeToFirstByte.isValid) timeToFirstByte.update({
      value,
      entries
    });
  });
} else {
  if (!timeToFirstByte.isValid) {
    const entry = {};
    // convert real timestamps to relative timestamps to match web-vitals behavior
    for (let key in _runtime.globalScope?.performance?.timing || {}) entry[key] = Math.max(_runtime.globalScope?.performance?.timing[key] - _runtime.offset, 0);

    // ttfb is equiv to document's responseStart property in timing API --> https://developer.mozilla.org/en-US/docs/Web/API/PerformanceTiming/responseStart
    timeToFirstByte.update({
      value: entry.responseStart,
      entries: [entry]
    });
  }
}