"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkState = checkState;
exports.onDOMContentLoaded = onDOMContentLoaded;
exports.onWindowLoad = onWindowLoad;
var _eventListenerOpts = require("../event-listener/event-listener-opts");
function checkState() {
  return typeof document === 'undefined' || document.readyState === 'complete';
}
function onWindowLoad(cb, useCapture) {
  if (checkState()) return cb();
  (0, _eventListenerOpts.windowAddEventListener)('load', cb, useCapture);
}
function onDOMContentLoaded(cb) {
  if (checkState()) return cb();
  (0, _eventListenerOpts.documentAddEventListener)('DOMContentLoaded', cb);
}