"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NREUMinitialized = NREUMinitialized;
exports.addToNREUM = addToNREUM;
exports.defaults = void 0;
exports.getNREUMInitializedAgent = getNREUMInitializedAgent;
exports.gosCDN = gosCDN;
exports.gosNREUM = gosNREUM;
exports.gosNREUMInfo = gosNREUMInfo;
exports.gosNREUMInit = gosNREUMInit;
exports.gosNREUMLoaderConfig = gosNREUMLoaderConfig;
exports.gosNREUMOriginals = gosNREUMOriginals;
exports.setNREUMInitializedAgent = setNREUMInitializedAgent;
var _now = require("../timing/now");
var _runtime = require("../constants/runtime");
const defaults = exports.defaults = {
  beacon: 'bam.nr-data.net',
  errorBeacon: 'bam.nr-data.net'
};
function gosNREUM() {
  if (!_runtime.globalScope.NREUM) {
    _runtime.globalScope.NREUM = {};
  }
  if (typeof _runtime.globalScope.newrelic === 'undefined') _runtime.globalScope.newrelic = _runtime.globalScope.NREUM;
  return _runtime.globalScope.NREUM;
}
function gosNREUMInfo() {
  let nr = gosNREUM();
  const externallySupplied = nr.info || {};
  nr.info = {
    beacon: defaults.beacon,
    errorBeacon: defaults.errorBeacon,
    ...externallySupplied
  };
  return nr;
}
function gosNREUMLoaderConfig() {
  let nr = gosNREUM();
  const externallySupplied = nr.loader_config || {};
  nr.loader_config = {
    ...externallySupplied
  };
  return nr;
}
function gosNREUMInit() {
  let nr = gosNREUM();
  const externallySupplied = nr.init || {};
  nr.init = {
    ...externallySupplied
  };
  return nr;
}
function gosNREUMOriginals() {
  let nr = gosNREUM();
  if (!nr.o) {
    nr.o = {
      ST: _runtime.globalScope.setTimeout,
      SI: _runtime.globalScope.setImmediate,
      CT: _runtime.globalScope.clearTimeout,
      XHR: _runtime.globalScope.XMLHttpRequest,
      REQ: _runtime.globalScope.Request,
      EV: _runtime.globalScope.Event,
      PR: _runtime.globalScope.Promise,
      MO: _runtime.globalScope.MutationObserver,
      // this'll be undefined if not in a web window
      FETCH: _runtime.globalScope.fetch
    };
  }
  return nr;
}
function setNREUMInitializedAgent(id, newAgentInstance) {
  let nr = gosNREUM();
  nr.initializedAgents ??= {};
  newAgentInstance.initializedAt = {
    ms: (0, _now.now)(),
    date: new Date()
  };
  nr.initializedAgents[id] = newAgentInstance;
}

/**
 * Get the agent instance under the associated identifier on the global newrelic object.
 * @see setNREUMInitializedAgents
 * @returns Existing agent instance under newrelic.initializedAgent[id], or undefined if it does not exist.
 */
function getNREUMInitializedAgent(id) {
  let nr = gosNREUM();
  return nr.initializedAgents?.[id];
}
function addToNREUM(fnName, fn) {
  let nr = gosNREUM();
  nr[fnName] = fn;
}
function NREUMinitialized() {
  const nr = gosNREUM();
  nr.initialized = true;
}
function gosCDN() {
  gosNREUMInfo();
  gosNREUMInit();
  gosNREUMOriginals();
  gosNREUMLoaderConfig();
  return gosNREUM();
}