"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Aggregate = void 0;
var _runtime = require("../../../common/constants/runtime");
var _navTiming = require("../../../common/timing/nav-timing");
var _stringify = require("../../../common/util/stringify");
var _config = require("../../../common/config/config");
var _harvest = require("../../../common/harvest/harvest");
var CONSTANTS = _interopRequireWildcard(require("../constants"));
var _initializedFeatures = require("./initialized-features");
var _featureFlags = require("../../../common/util/feature-flags");
var _console = require("../../../common/util/console");
var _aggregateBase = require("../../utils/aggregate-base");
var _firstContentfulPaint = require("../../../common/vitals/first-contentful-paint");
var _firstPaint = require("../../../common/vitals/first-paint");
var _timeToFirstByte = require("../../../common/vitals/time-to-first-byte");
var _drain = require("../../../common/drain/drain");
var _features = require("../../../loaders/features/features");
var _handle = require("../../../common/event-emitter/handle");
var _constants2 = require("../../metrics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Aggregate extends _aggregateBase.AggregateBase {
  static featureName = CONSTANTS.FEATURE_NAME;
  constructor(agentIdentifier, aggregator) {
    super(agentIdentifier, aggregator, CONSTANTS.FEATURE_NAME);
    this.timeToFirstByte = 0;
    this.firstByteToWindowLoad = 0; // our "frontend" duration
    this.firstByteToDomContent = 0; // our "dom processing" duration

    if (_runtime.isBrowserScope) {
      _timeToFirstByte.timeToFirstByte.subscribe(_ref => {
        let {
          value,
          entries
        } = _ref;
        const navEntry = entries[0];
        this.timeToFirstByte = Math.max(value, this.timeToFirstByte);
        this.firstByteToWindowLoad = Math.max(Math.round(navEntry.loadEventEnd - this.timeToFirstByte), this.firstByteToWindowLoad); // our "frontend" duration
        this.firstByteToDomContent = Math.max(Math.round(navEntry.domContentLoadedEventEnd - this.timeToFirstByte), this.firstByteToDomContent); // our "dom processing" duration

        this.sendRum();
      });
    } else {
      // worker agent build does not get TTFB values, use default 0 values
      this.sendRum();
    }
  }
  sendRum() {
    const info = (0, _config.getInfo)(this.agentIdentifier);
    const agentRuntime = (0, _config.getRuntime)(this.agentIdentifier);
    const harvester = new _harvest.Harvest(this);
    if (!info.beacon) return;
    if (info.queueTime) this.aggregator.store('measures', 'qt', {
      value: info.queueTime
    });
    if (info.applicationTime) this.aggregator.store('measures', 'ap', {
      value: info.applicationTime
    });

    // These 3 values should've been recorded after load and before this func runs. They are part of the minimum required for PageView events to be created.
    // Following PR #428, which demands that all agents send RUM call, these need to be sent even outside of the main window context where PerformanceTiming
    // or PerformanceNavigationTiming do not exists. Hence, they'll be filled in by 0s instead in, for example, worker threads that still init the PVE module.
    this.aggregator.store('measures', 'be', {
      value: this.timeToFirstByte
    });
    this.aggregator.store('measures', 'fe', {
      value: this.firstByteToWindowLoad
    });
    this.aggregator.store('measures', 'dc', {
      value: this.firstByteToDomContent
    });
    const queryParameters = {
      tt: info.ttGuid,
      us: info.user,
      ac: info.account,
      pr: info.product,
      af: (0, _initializedFeatures.getActivatedFeaturesFlags)(this.agentIdentifier).join(','),
      ...Object.entries(this.aggregator.get('measures') || {}).reduce((aggregator, _ref2) => {
        let [metricName, measure] = _ref2;
        aggregator[metricName] = measure.params?.value;
        return aggregator;
      }, {}),
      xx: info.extra,
      ua: info.userAttributes,
      at: info.atts
    };
    if (agentRuntime.session) queryParameters.fsh = Number(agentRuntime.session.isNew); // "first session harvest" aka RUM request or PageView event of a session

    let body;
    if (typeof info.jsAttributes === 'object' && Object.keys(info.jsAttributes).length > 0) {
      body = {
        ja: info.jsAttributes
      };
    }
    if (_runtime.globalScope.performance) {
      if (typeof PerformanceNavigationTiming !== 'undefined') {
        // Navigation Timing level 2 API that replaced PerformanceTiming & PerformanceNavigation
        const navTimingEntry = _runtime.globalScope?.performance?.getEntriesByType('navigation')?.[0];
        const perf = {
          timing: (0, _navTiming.addPT)(agentRuntime.offset, navTimingEntry, {}),
          navigation: (0, _navTiming.addPN)(navTimingEntry, {})
        };
        queryParameters.perf = (0, _stringify.stringify)(perf);
      } else if (typeof PerformanceTiming !== 'undefined') {
        // Safari pre-15 did not support level 2 timing
        const perf = {
          timing: (0, _navTiming.addPT)(agentRuntime.offset, _runtime.globalScope.performance.timing, {}, true),
          navigation: (0, _navTiming.addPN)(_runtime.globalScope.performance.navigation, {})
        };
        queryParameters.perf = (0, _stringify.stringify)(perf);
      }
    }
    queryParameters.fp = _firstPaint.firstPaint.current.value;
    queryParameters.fcp = _firstContentfulPaint.firstContentfulPaint.current.value;
    const rumStartTime = this.timeKeeper.now();
    harvester.send({
      endpoint: 'rum',
      payload: {
        qs: queryParameters,
        body
      },
      opts: {
        needResponse: true,
        sendEmptyBody: true
      },
      cbFinished: _ref3 => {
        let {
          status,
          responseText,
          xhr
        } = _ref3;
        const rumEndTime = this.timeKeeper.now();
        if (status >= 400 || status === 0) {
          // Adding retry logic for the rum call will be a separate change
          this.ee.abort();
          return;
        }
        try {
          this.timeKeeper.processRumRequest(xhr, rumStartTime, rumEndTime);
        } catch (error) {
          (0, _handle.handle)(_constants2.SUPPORTABILITY_METRIC_CHANNEL, ['PVE/NRTime/Calculation/Failed'], undefined, _features.FEATURE_NAMES.metrics, this.ee);
          (0, _drain.drain)(this.agentIdentifier, _features.FEATURE_NAMES.metrics, true);
          this.ee.abort();
          (0, _console.warn)('Could not calculate New Relic server time. Agent shutting down.');
          return;
        }
        try {
          const {
            app,
            ...flags
          } = JSON.parse(responseText);
          agentRuntime.appMetadata = app;
          (0, _featureFlags.activateFeatures)(flags, this.agentIdentifier);
          this.drain();
        } catch (err) {
          this.ee.abort();
          (0, _console.warn)('RUM call failed. Agent shutting down.', err);
        }
      }
    });
  }
}
exports.Aggregate = Aggregate;