"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instrument = void 0;
var _handle = require("../../../common/event-emitter/handle");
var _pageVisibility = require("../../../common/window/page-visibility");
var _eventListenerOpts = require("../../../common/event-listener/event-listener-opts");
var _now = require("../../../common/timing/now");
var _instrumentBase = require("../../utils/instrument-base");
var _constants = require("../constants");
var _runtime = require("../../../common/constants/runtime");
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

class Instrument extends _instrumentBase.InstrumentBase {
  static featureName = _constants.FEATURE_NAME;
  constructor(agentIdentifier, aggregator) {
    let auto = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    super(agentIdentifier, aggregator, _constants.FEATURE_NAME, auto);
    if (!_runtime.isBrowserScope) return; // CWV is irrelevant outside web context

    // While we try to replicate web-vital's visibilitywatcher logic in an effort to defer that library to post-pageload, this isn't perfect and doesn't consider prerendering.
    (0, _pageVisibility.subscribeToVisibilityChange)(() => (0, _handle.handle)('docHidden', [(0, _now.now)()], undefined, _constants.FEATURE_NAME, this.ee), true);

    // Window fires its pagehide event (typically on navigation--this occurrence is a *subset* of vis change); don't defer this unless it's guarantee it cannot happen before load(?)
    (0, _eventListenerOpts.windowAddEventListener)('pagehide', () => (0, _handle.handle)('winPagehide', [(0, _now.now)()], undefined, _constants.FEATURE_NAME, this.ee));
    this.importAggregator();
  }
}
exports.Instrument = Instrument;