"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SR_EVENT_EMITTER_TYPES = exports.RRWEB_EVENT_TYPES = exports.QUERY_PARAM_PADDING = exports.MAX_PAYLOAD_SIZE = exports.IDEAL_PAYLOAD_SIZE = exports.FEATURE_NAME = exports.CHECKOUT_MS = exports.AVG_COMPRESSION = exports.ABORT_REASONS = void 0;
var _constants = require("../../common/session/constants");
var _features = require("../../loaders/features/features");
const FEATURE_NAME = exports.FEATURE_NAME = _features.FEATURE_NAMES.sessionReplay;
const SR_EVENT_EMITTER_TYPES = exports.SR_EVENT_EMITTER_TYPES = {
  RECORD: 'recordReplay',
  PAUSE: 'pauseReplay'
};
const AVG_COMPRESSION = exports.AVG_COMPRESSION = 0.12;
const RRWEB_EVENT_TYPES = exports.RRWEB_EVENT_TYPES = {
  DomContentLoaded: 0,
  Load: 1,
  FullSnapshot: 2,
  IncrementalSnapshot: 3,
  Meta: 4,
  Custom: 5
};
/** Vortex caps payload sizes at 1MB */
const MAX_PAYLOAD_SIZE = exports.MAX_PAYLOAD_SIZE = 1000000;
/** Unloading caps around 64kb */
const IDEAL_PAYLOAD_SIZE = exports.IDEAL_PAYLOAD_SIZE = 64000;
/** Interval between forcing new full snapshots -- 15 seconds in error mode (x2), 5 minutes in full mode */
const CHECKOUT_MS = exports.CHECKOUT_MS = {
  [_constants.MODE.ERROR]: 15000,
  [_constants.MODE.FULL]: 300000,
  [_constants.MODE.OFF]: 0
};
const ABORT_REASONS = exports.ABORT_REASONS = {
  RESET: {
    message: 'Session was reset',
    sm: 'Reset'
  },
  IMPORT: {
    message: 'Recorder failed to import',
    sm: 'Import'
  },
  TOO_MANY: {
    message: '429: Too Many Requests',
    sm: 'Too-Many'
  },
  TOO_BIG: {
    message: 'Payload was too large',
    sm: 'Too-Big'
  },
  CROSS_TAB: {
    message: 'Session Entity was set to OFF on another tab',
    sm: 'Cross-Tab'
  },
  ENTITLEMENTS: {
    message: 'Session Replay is not allowed and will not be started',
    sm: 'Entitlement'
  }
};
/** Reserved room for query param attrs */
const QUERY_PARAM_PADDING = exports.QUERY_PARAM_PADDING = 5000;