"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instrument = void 0;
var _constants = require("../../../common/session/constants");
var _instrumentBase = require("../../utils/instrument-base");
var _constants2 = require("../constants");
var _utils = require("../shared/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright 2023 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */ /**
 * @file Primes the Session Replay feature for lazy loading.
 *
 * NOTE: This code is under development and dormant. It will not download to instrumented pages or record any data.
 * It is not production ready, and is not intended to be imported or implemented in any build of the browser agent until
 * functionality is validated and a full user experience is curated.
 */
class Instrument extends _instrumentBase.InstrumentBase {
  static featureName = _constants2.FEATURE_NAME;
  constructor(agentIdentifier, aggregator) {
    let auto = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    super(agentIdentifier, aggregator, _constants2.FEATURE_NAME, auto);
    let session;
    try {
      session = JSON.parse(localStorage.getItem("".concat(_constants.PREFIX, "_").concat(_constants.DEFAULT_KEY)));
    } catch (err) {}
    if (this.#canPreloadRecorder(session)) {
      this.#startRecording(session?.sessionReplayMode);
    } else {
      this.importAggregator();
    }
  }

  // At this point wherein session state exists already but we haven't init SessionEntity aka verify timers.
  #canPreloadRecorder(session) {
    if (!session) {
      // this might be a new session if entity initializes: conservatively start recording if first-time config allows
      // Note: users with SR enabled, as well as these other configs enabled by-default, will be penalized by the recorder overhead EVEN IF they don't actually have or get
      // entitlement or sampling decision, or otherwise intentionally opted-in for the feature.
      return (0, _utils.isPreloadAllowed)(this.agentIdentifier);
    } else if (session.sessionReplayMode === _constants.MODE.FULL || session.sessionReplayMode === _constants.MODE.ERROR) {
      return true; // existing sessions get to continue recording, regardless of this page's configs or if it has expired (conservatively)
    } else {
      // SR mode was OFF but may potentially be turned on if session resets and configs allows the new session to have replay...
      return (0, _utils.isPreloadAllowed)(this.agentIdentifier);
    }
  }
  async #startRecording(mode) {
    const {
      Recorder
    } = await Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "recorder" */'../shared/recorder')));
    this.recorder = new Recorder({
      mode,
      agentIdentifier: this.agentIdentifier
    });
    this.recorder.startRecording();
    this.abortHandler = this.recorder.stopRecording;
    this.importAggregator({
      recorder: this.recorder
    });
  }
}
exports.Instrument = Instrument;