"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSessionReplayMode = getSessionReplayMode;
var _config = require("../../../common/config/config");
var _nreum = require("../../../common/window/nreum");
var _sharedChannel = require("../../../common/constants/shared-channel");
var _constants = require("../../../common/session/constants");
/**
 * Figure out if the Replay feature is running (what mode it's in).
 * IMPORTANT: Session tracking is assumed to be ON; if applicable, check init's privacy.cookies_enabled setting before using this fn!
 * CRITICAL: This fn must be called prior to ALL features aggregate draining. If not, it will never resolve.
 * @param {String} agentId
 * @returns Promise that resolves to one of the values in MODE enum
 */
async function getSessionReplayMode(agentId) {
  try {
    const newrelic = (0, _nreum.gosNREUM)();
    // Should be enabled by configuration and using an agent build that includes it (via checking that the instrument class was initialized).
    if ((0, _config.getConfigurationValue)(agentId, 'session_replay.enabled') && typeof newrelic.initializedAgents[agentId].features.session_replay === 'object') {
      const srInitialized = await newrelic.initializedAgents[agentId].features.session_replay.onAggregateImported;
      if (srInitialized) return await _sharedChannel.sharedChannel.sessionReplayInitialized; // wait for replay to determine which mode it's after running its sampling logic
    }
  } catch (e) {/* exception ==> off */}
  return _constants.MODE.OFF; // at any step of the way s.t. SR cannot be on by implication or is explicitly off
}