"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canImportReplayAgg = canImportReplayAgg;
exports.enableSessionTracking = void 0;
exports.isPreloadAllowed = isPreloadAllowed;
var _config = require("../../../common/config/config");
var _runtime = require("../../../common/constants/runtime");
const enableSessionTracking = agentId => _runtime.isBrowserScope && (0, _config.getConfigurationValue)(agentId, 'privacy.cookies_enabled') === true;
exports.enableSessionTracking = enableSessionTracking;
function hasReplayPrerequisite(agentId) {
  return _config.originals.MO &&
  // Session Replay cannot work without Mutation Observer
  enableSessionTracking &&
  // requires session tracking to be running (hence "session" replay...)
  (0, _config.getConfigurationValue)(agentId, 'session_trace.enabled') === true; // Session Replay as of now is tightly coupled with Session Trace in the UI
}
function isPreloadAllowed(agentId) {
  return (0, _config.getConfigurationValue)(agentId, 'session_replay.preload') === true && hasReplayPrerequisite(agentId);
}
function canImportReplayAgg(agentId, sessionMgr) {
  if (!hasReplayPrerequisite(agentId)) return false;
  return !!sessionMgr?.isNew || !!sessionMgr?.state.sessionReplayMode; // Session Replay should only try to run if already running from a previous page, or at the beginning of a session
}