"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instrument = void 0;
var _handle = require("../../../common/event-emitter/handle");
var _wrap = require("../../../common/wrap");
var _now = require("../../../common/timing/now");
var _instrumentBase = require("../../utils/instrument-base");
var CONSTANTS = _interopRequireWildcard(require("../constants"));
var _features = require("../../../loaders/features/features");
var _runtime = require("../../../common/constants/runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

const {
  BST_RESOURCE,
  RESOURCE,
  START,
  END,
  FEATURE_NAME,
  FN_END,
  FN_START,
  PUSH_STATE
} = CONSTANTS;
class Instrument extends _instrumentBase.InstrumentBase {
  static featureName = FEATURE_NAME;
  constructor(agentIdentifier, aggregator) {
    let auto = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    super(agentIdentifier, aggregator, FEATURE_NAME, auto);
    if (!_runtime.isBrowserScope) return; // session traces not supported outside web env

    const thisInstrumentEE = this.ee;
    (0, _wrap.wrapHistory)(thisInstrumentEE);
    this.eventsEE = (0, _wrap.wrapEvents)(thisInstrumentEE);
    this.eventsEE.on(FN_START, function (args, target) {
      this.bstStart = (0, _now.now)();
    });
    this.eventsEE.on(FN_END, function (args, target) {
      // ISSUE: when target is XMLHttpRequest, nr@context should have params so we can calculate event origin
      // When ajax is disabled, this may fail without making ajax a dependency of session_trace
      (0, _handle.handle)('bst', [args[0], target, this.bstStart, (0, _now.now)()], undefined, _features.FEATURE_NAMES.sessionTrace, thisInstrumentEE);
    });
    thisInstrumentEE.on(PUSH_STATE + START, function (args) {
      this.time = (0, _now.now)();
      this.startPath = location.pathname + location.hash;
    });
    thisInstrumentEE.on(PUSH_STATE + END, function (args) {
      (0, _handle.handle)('bstHist', [location.pathname + location.hash, this.startPath, this.time], undefined, _features.FEATURE_NAMES.sessionTrace, thisInstrumentEE);
    });
    let observer;
    try {
      // Capture initial resources and watch for future ones. Don't defer this given there's a default cap on the number of buffered entries.
      observer = new PerformanceObserver(list => {
        // eslint-disable-line no-undef
        const entries = list.getEntries();
        (0, _handle.handle)(BST_RESOURCE, [entries], undefined, _features.FEATURE_NAMES.sessionTrace, thisInstrumentEE);
      });
      observer.observe({
        type: RESOURCE,
        buffered: true
      });
    } catch (e) {
      // Per NEWRELIC-8525, we don't have a fallback for capturing resources for older versions that don't support PO at this time.
    }
    this.importAggregator({
      resourceObserver: observer
    });
  }
}
exports.Instrument = Instrument;