"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AjaxNode = void 0;
var _belSerializer = require("../../../common/serialize/bel-serializer");
var _constants = require("../constants");
var _belNode = require("./bel-node");
class AjaxNode extends _belNode.BelNode {
  constructor(agentIdentifier, ajaxEvent) {
    super(agentIdentifier);
    this.belType = _constants.NODE_TYPE.AJAX;
    this.method = ajaxEvent.method;
    this.status = ajaxEvent.status;
    this.domain = ajaxEvent.domain;
    this.path = ajaxEvent.path;
    this.txSize = ajaxEvent.requestSize;
    this.rxSize = ajaxEvent.responseSize;
    this.requestedWith = ajaxEvent.type === 'fetch' ? 1 : ''; // 'xhr' and 'beacon' types get the empty string
    this.spanId = ajaxEvent.spanId;
    this.traceId = ajaxEvent.traceId;
    this.spanTimestamp = ajaxEvent.spanTimestamp;
    this.gql = ajaxEvent.gql;
    this.start = ajaxEvent.startTime;
    this.end = ajaxEvent.endTime;
  }
  serialize(parentStartTimestamp) {
    const addString = (0, _belSerializer.getAddStringContext)(this.agentIdentifier);
    const nodeList = [];

    // IMPORTANT: The order in which addString is called matters and correlates to the order in which string shows up in the harvest payload. Do not re-order the following code.
    const fields = [(0, _belSerializer.numeric)(this.belType), 0,
    // this will be overwritten below with number of attached nodes
    (0, _belSerializer.numeric)(this.start - parentStartTimestamp),
    // start relative to parent start (if part of first node in payload) or first parent start
    (0, _belSerializer.numeric)(this.end - this.start),
    // end is relative to start
    (0, _belSerializer.numeric)(this.callbackEnd), (0, _belSerializer.numeric)(this.callbackDuration), addString(this.method), (0, _belSerializer.numeric)(this.status), addString(this.domain), addString(this.path), (0, _belSerializer.numeric)(this.txSize), (0, _belSerializer.numeric)(this.rxSize), this.requestedWith, addString(this.nodeId), (0, _belSerializer.nullable)(this.spanId, addString, true) + (0, _belSerializer.nullable)(this.traceId, addString, true) + (0, _belSerializer.nullable)(this.spanTimestamp, _belSerializer.numeric)];
    let allAttachedNodes = [];
    if (typeof this.gql === 'object') allAttachedNodes = (0, _belSerializer.addCustomAttributes)(this.gql, addString);
    this.children.forEach(node => allAttachedNodes.push(node.serialize())); // no children is expected under ajax nodes at this time

    fields[1] = (0, _belSerializer.numeric)(allAttachedNodes.length);
    nodeList.push(fields);
    if (allAttachedNodes.length) nodeList.push(allAttachedNodes.join(';'));
    return nodeList.join(';');
  }
}
exports.AjaxNode = AjaxNode;