"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InitialPageLoadInteraction = void 0;
var _navTiming = require("../../../common/timing/nav-timing");
var _interaction = require("./interaction");
var _belSerializer = require("../../../common/serialize/bel-serializer");
var _firstPaint = require("../../../common/vitals/first-paint");
var _firstContentfulPaint = require("../../../common/vitals/first-contentful-paint");
var _config = require("../../../common/config/config");
class InitialPageLoadInteraction extends _interaction.Interaction {
  constructor(agentIdentifier) {
    super(agentIdentifier, 'initialPageLoad', 0, null);
    const agentInfo = (0, _config.getInfo)(agentIdentifier);
    this.queueTime = agentInfo.queueTime;
    this.appTime = agentInfo.applicationTime;
  }
  get firstPaint() {
    return _firstPaint.firstPaint.current.value;
  }
  get firstContentfulPaint() {
    return _firstContentfulPaint.firstContentfulPaint.current.value;
  }

  /**
   * Build the navTiming node. This assumes the navTimingValues array in nav-timing.js has already been filled with values via the PageViewEvent feature having
   * executed the addPT function first and foremost.
   */
  get navTiming() {
    if (!_navTiming.navTimingValues.length) return;
    /*
    1. we initialize the seperator to ',' (seperates the nodeType id from the first value)
    2. we initialize the navTiming node to 'b' (the nodeType id)
    3. if the value is present, we add the seperator followed by the value;
       otherwise:
        - we add null seperator ('!') to the navTimingNode
        - we set the seperator to an empty string since we already wrote it above
      the reason for writing the null seperator instead of setting the seperator
      is to ensure we still write it if the null is the last navTiming value.
    */
    let seperator = ',';
    let navTimingNode = 'b';
    let prev = 0;

    // Get all navTiming values except offset aka timeOrigin since we just consider that (this.start) 0.
    // These are the latter 20 of the 21 timings appended by addPT:
    _navTiming.navTimingValues.slice(1, 21).forEach(v => {
      if (v !== undefined) {
        navTimingNode += seperator + (0, _belSerializer.numeric)(v - prev);
        seperator = ',';
        prev = v;
      } else {
        navTimingNode += seperator + '!';
        seperator = '';
      }
    });
    return navTimingNode;
  }
}
exports.InitialPageLoadInteraction = InitialPageLoadInteraction;