"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instrument = void 0;
var _config = require("../../../common/config/config");
var _runtime = require("../../../common/constants/runtime");
var _handle = require("../../../common/event-emitter/handle");
var _eventListenerOpts = require("../../../common/event-listener/event-listener-opts");
var _now = require("../../../common/timing/now");
var _invoke = require("../../../common/util/invoke");
var _wrap = require("../../../common/wrap");
var _instrumentBase = require("../../utils/instrument-base");
var _constants = require("../constants");
/** The minimal time after a UI event for which no further events will be processed - i.e. a throttling rate to reduce spam.
 * This also give some time for the new interaction to complete without being discarded by a subsequent UI event and wrongly attributed.
 * This value is still subject to change and critique, as it is derived from beyond worst case time to next frame of a page.
 */
const UI_WAIT_INTERVAL = 1 / 10 * 1000; // assume 10 fps

class Instrument extends _instrumentBase.InstrumentBase {
  static featureName = _constants.FEATURE_NAME;
  constructor(agentIdentifier, aggregator) {
    let auto = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    super(agentIdentifier, aggregator, _constants.FEATURE_NAME, auto);
    if (!_runtime.isBrowserScope || !_config.originals.MO) return; // soft navigations is not supported outside web env or browsers without the mutation observer API

    const historyEE = (0, _wrap.wrapHistory)(this.ee);
    const eventsEE = (0, _wrap.wrapEvents)(this.ee);
    const trackURLChange = () => (0, _handle.handle)('newURL', [(0, _now.now)(), '' + window.location], undefined, this.featureName, this.ee);
    historyEE.on('pushState-end', trackURLChange);
    historyEE.on('replaceState-end', trackURLChange);
    try {
      this.removeOnAbort = new AbortController();
    } catch (e) {}
    const trackURLChangeEvent = evt => (0, _handle.handle)('newURL', [evt.timeStamp, '' + window.location], undefined, this.featureName, this.ee);
    (0, _eventListenerOpts.windowAddEventListener)('popstate', trackURLChangeEvent, true, this.removeOnAbort?.signal);
    let oncePerFrame = false; // attempt to reduce dom noice since the observer runs very frequently with below options
    const domObserver = new _config.originals.MO((domChanges, observer) => {
      if (oncePerFrame) return;
      oncePerFrame = true;
      requestAnimationFrame(() => {
        // waiting for next frame to time when any visuals are supposedly updated
        (0, _handle.handle)('newDom', [(0, _now.now)()], undefined, this.featureName, this.ee);
        oncePerFrame = false;
      });
    });
    const processUserInteraction = (0, _invoke.debounce)(event => {
      (0, _handle.handle)('newUIEvent', [event], undefined, this.featureName, this.ee);
      domObserver.observe(document.body, {
        attributes: true,
        childList: true,
        subtree: true,
        characterData: true
      });
    }, UI_WAIT_INTERVAL, {
      leading: true
    });
    eventsEE.on('fn-start', _ref => {
      let [evt] = _ref;
      // set up a new user ixn before the callback for the triggering event executes
      if (_constants.INTERACTION_TRIGGERS.includes(evt?.type)) {
        processUserInteraction(evt);
      }
    });
    for (let eventType of _constants.INTERACTION_TRIGGERS) document.addEventListener(eventType, () => {/* no-op, this ensures the UI events are monitored by our callback above */});
    this.abortHandler = abort;
    this.importAggregator({
      domObserver
    });
    function abort() {
      this.removeOnAbort?.abort();
      domObserver.disconnect();
      this.abortHandler = undefined; // weakly allow this abort op to run only once
    }
  }
}
exports.Instrument = Instrument;