"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instrument = void 0;
var _wrap = require("../../../common/wrap");
var _eventListenerOpts = require("../../../common/event-listener/event-listener-opts");
var _instrumentBase = require("../../utils/instrument-base");
var _config = require("../../../common/config/config");
var _now = require("../../../common/timing/now");
var CONSTANTS = _interopRequireWildcard(require("../constants"));
var _runtime = require("../../../common/constants/runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
*/

const {
  FEATURE_NAME,
  START,
  END,
  BODY,
  CB_END,
  JS_TIME,
  FETCH,
  FN_START,
  CB_START,
  FN_END
} = CONSTANTS;
class Instrument extends _instrumentBase.InstrumentBase {
  static featureName = FEATURE_NAME;
  constructor(agentIdentifier, aggregator) {
    let auto = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    super(agentIdentifier, aggregator, FEATURE_NAME, auto);
    if (!_runtime.isBrowserScope) return; // SPA not supported outside web env

    if (!(0, _config.getRuntime)(agentIdentifier).xhrWrappable) return;
    try {
      this.removeOnAbort = new AbortController();
    } catch (e) {}
    let depth = 0;
    let startHash;
    const tracerEE = this.ee.get('tracer');
    const jsonpEE = (0, _wrap.wrapJsonP)(this.ee);
    const promiseEE = (0, _wrap.wrapPromise)(this.ee);
    const timerEE = (0, _wrap.wrapTimer)(this.ee);
    const xhrEE = (0, _wrap.wrapXhr)(this.ee);
    const eventsEE = this.ee.get('events'); // wrapXhr will call wrapEvents
    const fetchEE = (0, _wrap.wrapFetch)(this.ee);
    const historyEE = (0, _wrap.wrapHistory)(this.ee);
    const mutationEE = (0, _wrap.wrapMutation)(this.ee);
    this.ee.on(FN_START, startTimestamp);
    promiseEE.on(CB_START, startTimestamp);
    jsonpEE.on(CB_START, startTimestamp);
    this.ee.on(FN_END, endTimestamp);
    promiseEE.on(CB_END, endTimestamp);
    jsonpEE.on(CB_END, endTimestamp);
    this.ee.buffer([FN_START, FN_END, 'xhr-resolved'], this.featureName);
    eventsEE.buffer([FN_START], this.featureName);
    timerEE.buffer(['setTimeout' + END, 'clearTimeout' + START, FN_START], this.featureName);
    xhrEE.buffer([FN_START, 'new-xhr', 'send-xhr' + START], this.featureName);
    fetchEE.buffer([FETCH + START, FETCH + '-done', FETCH + BODY + START, FETCH + BODY + END], this.featureName);
    historyEE.buffer(['newURL'], this.featureName);
    mutationEE.buffer([FN_START], this.featureName);
    promiseEE.buffer(['propagate', CB_START, CB_END, 'executor-err', 'resolve' + START], this.featureName);
    tracerEE.buffer([FN_START, 'no-' + FN_START], this.featureName);
    jsonpEE.buffer(['new-jsonp', 'cb-start', 'jsonp-error', 'jsonp-end'], this.featureName);
    timestamp(fetchEE, FETCH + START);
    timestamp(fetchEE, FETCH + '-done');
    timestamp(jsonpEE, 'new-jsonp');
    timestamp(jsonpEE, 'jsonp-end');
    timestamp(jsonpEE, 'cb-start');
    historyEE.on('pushState-end', trackURLChange);
    historyEE.on('replaceState-end', trackURLChange);
    window.addEventListener('hashchange', trackURLChange, (0, _eventListenerOpts.eventListenerOpts)(true, this.removeOnAbort?.signal));
    window.addEventListener('load', trackURLChange, (0, _eventListenerOpts.eventListenerOpts)(true, this.removeOnAbort?.signal));
    window.addEventListener('popstate', function () {
      trackURLChange(0, depth > 1);
    }, (0, _eventListenerOpts.eventListenerOpts)(true, this.removeOnAbort?.signal));
    function trackURLChange(unusedArgs, hashChangedDuringCb) {
      historyEE.emit('newURL', ['' + window.location, hashChangedDuringCb]);
    }
    function startTimestamp() {
      depth++;
      startHash = window.location.hash;
      this[FN_START] = (0, _now.now)();
    }
    function endTimestamp() {
      depth--;
      if (window.location.hash !== startHash) {
        trackURLChange(0, true);
      }
      var time = (0, _now.now)();
      this[JS_TIME] = ~~this[JS_TIME] + time - this[FN_START];
      this[FN_END] = time;
    }
    function timestamp(ee, type) {
      ee.on(type, function () {
        this[type] = (0, _now.now)();
      });
    }
    this.abortHandler = this.#abort;
    this.importAggregator();
  }

  /** Restoration and resource release tasks to be done if SPA loader is being aborted. Unwind changes to globals and subscription to DOM events. */
  #abort() {
    this.removeOnAbort?.abort();
    this.abortHandler = undefined; // weakly allow this abort op to run only once
  }
}
exports.Instrument = Instrument;