"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupAgentSession = setupAgentSession;
var _config = require("../../common/config/config");
var _drain = require("../../common/drain/drain");
var _contextualEe = require("../../common/event-emitter/contextual-ee");
var _registerHandler = require("../../common/event-emitter/register-handler");
var _sessionEntity = require("../../common/session/session-entity");
var _localStorage = require("../../common/storage/local-storage.js");
var _firstPartyCookies = require("../../common/storage/first-party-cookies");
var _constants = require("../../common/session/constants");
let ranOnce = 0;
function setupAgentSession(agentIdentifier) {
  const agentRuntime = (0, _config.getRuntime)(agentIdentifier);
  if (ranOnce++) return agentRuntime.session;
  const sessionInit = (0, _config.getConfiguration)(agentIdentifier).session;
  /* Domain is a string that can be specified by customer. The only way to keep the session object across subdomains is using first party cookies.
    This determines which storage wrapper the session manager will use to keep state. */
  const storageTypeInst = sessionInit?.domain ? new _firstPartyCookies.FirstPartyCookies(sessionInit.domain) : new _localStorage.LocalStorage();
  agentRuntime.session = new _sessionEntity.SessionEntity({
    agentIdentifier,
    key: _constants.DEFAULT_KEY,
    storage: storageTypeInst,
    expiresMs: sessionInit?.expiresMs,
    inactiveMs: sessionInit?.inactiveMs
  });

  // Retrieve & re-add all of the persisted setCustomAttribute|setUserId k-v from previous page load(s), if any was stored.
  const customSessionData = agentRuntime.session.state.custom;
  const agentInfo = (0, _config.getInfo)(agentIdentifier);
  if (customSessionData) {
    agentInfo.jsAttributes = {
      ...agentInfo.jsAttributes,
      ...customSessionData
    };
  }
  const sharedEE = _contextualEe.ee.get(agentIdentifier);

  // any calls to newrelic.setCustomAttribute(<persisted>) will need to be added to:
  // local info.jsAttributes {}
  // the session's storage API
  (0, _registerHandler.registerHandler)('api-setCustomAttribute', (time, key, value) => {
    agentRuntime.session.syncCustomAttribute(key, value);
  }, 'session', sharedEE);

  // any calls to newrelic.setUserId(...) will need to be added to:
  // local info.jsAttributes {}
  // the session's storage API
  (0, _registerHandler.registerHandler)('api-setUserId', (time, key, value) => {
    agentRuntime.session.syncCustomAttribute(key, value);
  }, 'session', sharedEE);
  (0, _drain.drain)(agentIdentifier, 'session');
  return agentRuntime.session;
}