"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateBase = void 0;
var _featureBase = require("./feature-base");
var _config = require("../../common/config/config");
var _configure = require("../../loaders/configure/configure");
var _nreum = require("../../common/window/nreum");
var _drain = require("../../common/drain/drain");
var _featureFlags = require("../../common/util/feature-flags");
class AggregateBase extends _featureBase.FeatureBase {
  constructor() {
    super(...arguments);
    this.checkConfiguration();
  }

  /**
   * New handler for waiting for multiple flags. Useful when expecting multiple flags simultaneously (ex. stn vs sr)
   * @param {string[]} flagNames
   * @returns {Promise}
   */
  waitForFlags() {
    let flagNames = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    return new Promise((resolve, reject) => {
      if (_featureFlags.activatedFeatures[this.agentIdentifier]) {
        resolve(buildOutput(_featureFlags.activatedFeatures[this.agentIdentifier]));
      } else {
        this.ee.on('rumresp', function () {
          let resp = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          resolve(buildOutput(resp));
        });
      }
      function buildOutput(ref) {
        return flagNames.map(flag => {
          if (!ref[flag]) return 0;
          return ref[flag];
        });
      }
    });
  }
  drain() {
    (0, _drain.drain)(this.agentIdentifier, this.featureName);
  }

  /**
   * Checks for additional `jsAttributes` items to support backward compatibility with implementations of the agent where
   * loader configurations may appear after the loader code is executed.
   */
  checkConfiguration() {
    // NOTE: This check has to happen at aggregator load time
    if (!(0, _config.isConfigured)(this.agentIdentifier)) {
      let jsAttributes = {
        ...(0, _nreum.gosCDN)().info?.jsAttributes
      };
      try {
        jsAttributes = {
          ...jsAttributes,
          ...(0, _config.getInfo)(this.agentIdentifier)?.jsAttributes
        };
      } catch (err) {
        // do nothing
      }
      (0, _configure.configure)({
        agentIdentifier: this.agentIdentifier
      }, {
        ...(0, _nreum.gosCDN)(),
        info: {
          ...(0, _nreum.gosCDN)().info,
          jsAttributes
        },
        runtime: (0, _config.getRuntime)(this.agentIdentifier)
      });
    }
  }
}
exports.AggregateBase = AggregateBase;