"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lazyFeatureLoader = lazyFeatureLoader;
var _features = require("../../loaders/features/features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Centralizes the lazy loading of agent feature aggregate and instrument sources.
 *
 * This function uses two defined switch cases to allow us to easily name our chunks and re-use these
 * chunks for different agent types. We do not use template strings or string concatenation here because
 * doing so makes it much more difficult to name the chunks and forces Webpack to "guess" what the chunks
 * should be.
 * @param featureName Name of the feature to import such as ajax or session_trace
 * @param featurePart Name of the feature part to load; should be either instrument or aggregate
 * @returns {Promise<InstrumentBase|FeatureBase|null>}
 */
function lazyFeatureLoader(featureName, featurePart) {
  if (featurePart === 'aggregate') {
    switch (featureName) {
      case _features.FEATURE_NAMES.ajax:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "ajax-aggregate" */'../ajax/aggregate')));
      case _features.FEATURE_NAMES.jserrors:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "jserrors-aggregate" */'../jserrors/aggregate')));
      case _features.FEATURE_NAMES.metrics:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "metrics-aggregate" */'../metrics/aggregate')));
      case _features.FEATURE_NAMES.pageAction:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "page_action-aggregate" */'../page_action/aggregate')));
      case _features.FEATURE_NAMES.pageViewEvent:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "page_view_event-aggregate" */'../page_view_event/aggregate')));
      case _features.FEATURE_NAMES.pageViewTiming:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "page_view_timing-aggregate" */'../page_view_timing/aggregate')));
      case _features.FEATURE_NAMES.sessionReplay:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "session_replay-aggregate" */'../session_replay/aggregate')));
      case _features.FEATURE_NAMES.sessionTrace:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "session_trace-aggregate" */'../session_trace/aggregate')));
      case _features.FEATURE_NAMES.spa:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "spa-aggregate" */'../spa/aggregate')));
      case _features.FEATURE_NAMES.softNav:
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "basic-spa-aggregate" */'../soft_navigations/aggregate')));
      default:
        throw new Error("Attempted to load unsupported agent feature: ".concat(featureName, " ").concat(featurePart));
    }
  }
}