"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAPI = setAPI;
exports.setTopLevelCallers = setTopLevelCallers;
var _features = require("../features/features");
var _config = require("../../common/config/config");
var _handle = require("../../common/event-emitter/handle");
var _contextualEe = require("../../common/event-emitter/contextual-ee");
var _now = require("../../common/timing/now");
var _drain = require("../../common/drain/drain");
var _load = require("../../common/window/load");
var _runtime = require("../../common/constants/runtime");
var _console = require("../../common/util/console");
var _constants = require("../../features/metrics/constants");
var _nreum = require("../../common/window/nreum");
var _apiMethods = require("./api-methods");
var _constants2 = require("../../features/session_replay/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright 2020 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
function setTopLevelCallers() {
  const nr = (0, _nreum.gosCDN)();
  _apiMethods.apiMethods.forEach(f => {
    nr[f] = function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return caller(f, ...args);
    };
  });
  function caller(fnName) {
    for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
      args[_key2 - 1] = arguments[_key2];
    }
    let returnVals = [];
    Object.values(nr.initializedAgents).forEach(val => {
      if (val.exposed && val.api[fnName]) {
        returnVals.push(val.api[fnName](...args));
      }
    });
    return returnVals.length > 1 ? returnVals : returnVals[0];
  }
}
function setAPI(agentIdentifier, forceDrain) {
  let runSoftNavOverSpa = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (!forceDrain) (0, _drain.registerDrain)(agentIdentifier, 'api');
  const apiInterface = {};
  var instanceEE = _contextualEe.ee.get(agentIdentifier);
  var tracerEE = instanceEE.get('tracer');
  var prefix = 'api-';
  var spaPrefix = prefix + 'ixn-';

  // Setup stub functions that queue calls for later processing.
  _apiMethods.asyncApiMethods.forEach(fnName => {
    apiInterface[fnName] = apiCall(prefix, fnName, true, 'api');
  });
  apiInterface.addPageAction = apiCall(prefix, 'addPageAction', true, _features.FEATURE_NAMES.pageAction);
  apiInterface.setPageViewName = function (name, host) {
    if (typeof name !== 'string') return;
    if (name.charAt(0) !== '/') name = '/' + name;
    (0, _config.getRuntime)(agentIdentifier).customTransaction = (host || 'http://custom.transaction') + name;
    return apiCall(prefix, 'setPageViewName', true)();
  };

  /**
   * Attach the key-value attribute onto agent payloads. All browser events in NR will be affected.
   * @param {string} key
   * @param {string|number|null} value - null indicates the key should be removed or erased
   * @param {string} apiName
   * @param {boolean} addToBrowserStorage - whether this attribute should be stored in browser storage API and retrieved by the next agent context or initialization
   * @returns @see apiCall
   */
  function appendJsAttribute(key, value, apiName, addToBrowserStorage) {
    const currentInfo = (0, _config.getInfo)(agentIdentifier);
    if (value === null) {
      delete currentInfo.jsAttributes[key];
    } else {
      (0, _config.setInfo)(agentIdentifier, {
        ...currentInfo,
        jsAttributes: {
          ...currentInfo.jsAttributes,
          [key]: value
        }
      });
    }
    return apiCall(prefix, apiName, true, !!addToBrowserStorage || value === null ? 'session' : undefined)(key, value);
  }
  apiInterface.setCustomAttribute = function (name, value) {
    let persistAttribute = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (typeof name !== 'string') {
      (0, _console.warn)("Failed to execute setCustomAttribute.\nName must be a string type, but a type of <".concat(typeof name, "> was provided."));
      return;
    }
    if (!(['string', 'number', 'boolean'].includes(typeof value) || value === null)) {
      (0, _console.warn)("Failed to execute setCustomAttribute.\nNon-null value must be a string, number or boolean type, but a type of <".concat(typeof value, "> was provided."));
      return;
    }
    return appendJsAttribute(name, value, 'setCustomAttribute', persistAttribute);
  };
  /**
   * Attach the 'enduser.id' attribute onto agent payloads. This may be used in NR queries to group all browser events by specific users.
   * @param {string} value - unique user identifier; a null user id suggests none should exist
   * @returns @see apiCall
   */
  apiInterface.setUserId = function (value) {
    if (!(typeof value === 'string' || value === null)) {
      (0, _console.warn)("Failed to execute setUserId.\nNon-null value must be a string type, but a type of <".concat(typeof value, "> was provided."));
      return;
    }
    return appendJsAttribute('enduser.id', value, 'setUserId', true);
  };

  /**
   * Attach the 'applcation.version' attribute onto agent payloads. This may be used in NR queries to group all browser events by a specific customer-defined release.
   * @param {string|null} value - Application version -- if null, will "unset" the value
   * @returns @see apiCall
   */
  apiInterface.setApplicationVersion = function (value) {
    if (!(typeof value === 'string' || value === null)) {
      (0, _console.warn)("Failed to execute setApplicationVersion. Expected <String | null>, but got <".concat(typeof value, ">."));
      return;
    }
    return appendJsAttribute('application.version', value, 'setApplicationVersion', false);
  };
  apiInterface.start = features => {
    try {
      const smTag = !features ? 'undefined' : 'defined';
      (0, _handle.handle)(_constants.SUPPORTABILITY_METRIC_CHANNEL, ["API/start/".concat(smTag, "/called")], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
      const featNames = Object.values(_features.FEATURE_NAMES);
      if (features === undefined) features = featNames;else {
        features = Array.isArray(features) && features.length ? features : [features];
        if (features.some(f => !featNames.includes(f))) return (0, _console.warn)("Invalid feature name supplied. Acceptable feature names are: ".concat(featNames));
        if (!features.includes(_features.FEATURE_NAMES.pageViewEvent)) features.push(_features.FEATURE_NAMES.pageViewEvent);
      }
      features.forEach(feature => {
        instanceEE.emit("".concat(feature, "-opt-in"));
      });
    } catch (err) {
      (0, _console.warn)('An unexpected issue occurred', err);
    }
  };
  apiInterface[_constants2.SR_EVENT_EMITTER_TYPES.RECORD] = function () {
    (0, _handle.handle)(_constants.SUPPORTABILITY_METRIC_CHANNEL, ['API/recordReplay/called'], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
    (0, _handle.handle)(_constants2.SR_EVENT_EMITTER_TYPES.RECORD, [], undefined, _features.FEATURE_NAMES.sessionReplay, instanceEE);
  };
  apiInterface[_constants2.SR_EVENT_EMITTER_TYPES.PAUSE] = function () {
    (0, _handle.handle)(_constants.SUPPORTABILITY_METRIC_CHANNEL, ['API/pauseReplay/called'], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
    (0, _handle.handle)(_constants2.SR_EVENT_EMITTER_TYPES.PAUSE, [], undefined, _features.FEATURE_NAMES.sessionReplay, instanceEE);
  };
  apiInterface.interaction = function (options) {
    return new InteractionHandle().get(typeof options === 'object' ? options : {});
  };
  function InteractionHandle() {}
  const InteractionApiProto = InteractionHandle.prototype = {
    createTracer: function (name, cb) {
      var contextStore = {};
      var ixn = this;
      var hasCb = typeof cb === 'function';
      (0, _handle.handle)(_constants.SUPPORTABILITY_METRIC_CHANNEL, ['API/createTracer/called'], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
      // Soft navigations won't support Tracer nodes, but this fn should still work the same otherwise (e.g., run the orig cb).
      if (!runSoftNavOverSpa) (0, _handle.handle)(spaPrefix + 'tracer', [(0, _now.now)(), name, contextStore], ixn, _features.FEATURE_NAMES.spa, instanceEE);
      return function () {
        tracerEE.emit((hasCb ? '' : 'no-') + 'fn-start', [(0, _now.now)(), ixn, hasCb], contextStore);
        if (hasCb) {
          try {
            return cb.apply(this, arguments);
          } catch (err) {
            tracerEE.emit('fn-err', [arguments, this, err], contextStore);
            // the error came from outside the agent, so don't swallow
            throw err;
          } finally {
            tracerEE.emit('fn-end', [(0, _now.now)()], contextStore);
          }
        }
      };
    }
  };
  ['actionText', 'setName', 'setAttribute', 'save', 'ignore', 'onEnd', 'getContext', 'end', 'get'].forEach(name => {
    InteractionApiProto[name] = apiCall(spaPrefix, name, undefined, runSoftNavOverSpa ? _features.FEATURE_NAMES.softNav : _features.FEATURE_NAMES.spa);
  });
  apiInterface.setCurrentRouteName = runSoftNavOverSpa ? apiCall(spaPrefix, 'routeName', undefined, _features.FEATURE_NAMES.softNav) : apiCall(prefix, 'routeName', true, _features.FEATURE_NAMES.spa);
  function apiCall(prefix, name, notSpa, bufferGroup) {
    return function () {
      (0, _handle.handle)(_constants.SUPPORTABILITY_METRIC_CHANNEL, ['API/' + name + '/called'], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
      if (bufferGroup) (0, _handle.handle)(prefix + name, [(0, _now.now)(), ...arguments], notSpa ? null : this, bufferGroup, instanceEE); // no bufferGroup means only the SM is emitted
      return notSpa ? undefined : this; // returns the InteractionHandle which allows these methods to be chained
    };
  }
  apiInterface.noticeError = function (err, customAttributes) {
    if (typeof err === 'string') err = new Error(err);
    (0, _handle.handle)(_constants.SUPPORTABILITY_METRIC_CHANNEL, ['API/noticeError/called'], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
    (0, _handle.handle)('err', [err, (0, _now.now)(), false, customAttributes], undefined, _features.FEATURE_NAMES.jserrors, instanceEE);
  };

  // theres no window.load event on non-browser scopes, lazy load immediately
  if (!_runtime.isBrowserScope) lazyLoad();
  // try to stay out of the way of the window.load event, lazy load once that has finished.
  else (0, _load.onWindowLoad)(() => lazyLoad(), true);
  function lazyLoad() {
    Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "async-api" */'./apiAsync'))).then(_ref => {
      let {
        setAPI
      } = _ref;
      setAPI(agentIdentifier);
      (0, _drain.drain)(agentIdentifier, 'api');
    }).catch(() => {
      (0, _console.warn)('Downloading runtime APIs failed...');
      instanceEE.abort();
    });
  }
  return apiInterface;
}