"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAPI = setAPI;
var _features = require("../features/features");
var _config = require("../../common/config/config");
var _contextualEe = require("../../common/event-emitter/contextual-ee");
var _handle = require("../../common/event-emitter/handle");
var _registerHandler = require("../../common/event-emitter/register-handler");
var _invoke = require("../../common/util/invoke");
var _constants = require("../../features/metrics/constants");
function setAPI(agentIdentifier) {
  var instanceEE = _contextualEe.ee.get(agentIdentifier);
  var api = {
    finished: (0, _invoke.single)(finished),
    setErrorHandler,
    addToTrace,
    addRelease
  };

  // Hook all of the api functions up to the queues/stubs created in loader/api.js
  Object.entries(api).forEach(_ref => {
    let [fnName, fnCall] = _ref;
    return (0, _registerHandler.registerHandler)('api-' + fnName, fnCall, 'api', instanceEE);
  });

  // All API functions get passed the time they were called as their
  // first parameter. These functions can be called asynchronously.

  function finished(t, providedTime) {
    var time = providedTime ? providedTime - (0, _config.getRuntime)(agentIdentifier).offset : t;
    (0, _handle.handle)(_constants.CUSTOM_METRIC_CHANNEL, ['finished', {
      time
    }], undefined, _features.FEATURE_NAMES.metrics, instanceEE);
    addToTrace(t, {
      name: 'finished',
      start: time + (0, _config.getRuntime)(agentIdentifier).offset,
      origin: 'nr'
    });
    (0, _handle.handle)('api-addPageAction', [time, 'finished'], undefined, _features.FEATURE_NAMES.pageAction, instanceEE);
  }
  function addToTrace(t, evt) {
    if (!(evt && typeof evt === 'object' && evt.name && evt.start)) return;
    var report = {
      n: evt.name,
      s: evt.start - (0, _config.getRuntime)(agentIdentifier).offset,
      e: (evt.end || evt.start) - (0, _config.getRuntime)(agentIdentifier).offset,
      o: evt.origin || '',
      t: 'api'
    };
    (0, _handle.handle)('bstApi', [report], undefined, _features.FEATURE_NAMES.sessionTrace, instanceEE);
  }
  function setErrorHandler(t, handler) {
    (0, _config.getRuntime)(agentIdentifier).onerror = handler;
  }
  var releaseCount = 0;
  function addRelease(t, name, id) {
    if (++releaseCount > 10) return;
    (0, _config.getRuntime)(agentIdentifier).releaseIds[name.slice(-200)] = ('' + id).slice(-200);
  }
}