"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserAgent = void 0;
var _agent = require("./agent");
var _instrument = require("../features/page_view_event/instrument");
var _instrument2 = require("../features/page_view_timing/instrument");
var _instrument3 = require("../features/metrics/instrument");
var _instrument4 = require("../features/jserrors/instrument");
var _instrument5 = require("../features/ajax/instrument");
var _instrument6 = require("../features/session_trace/instrument");
var _instrument7 = require("../features/spa/instrument");
var _instrument8 = require("../features/page_action/instrument");
var _instrument9 = require("../features/session_replay/instrument");
/**
 * An agent class with all feature modules available. Features may be disabled and enabled via runtime configuration.
 * The BrowserAgent class is the most convenient and reliable option for most use cases.
 */
class BrowserAgent extends _agent.Agent {
  constructor(args) {
    super({
      ...args,
      features: [_instrument5.Instrument, _instrument.Instrument, _instrument2.Instrument, _instrument6.Instrument, _instrument3.Instrument, _instrument8.Instrument, _instrument4.Instrument, _instrument7.Instrument, _instrument9.Instrument],
      loaderType: 'browser-agent'
    });
  }
}
exports.BrowserAgent = BrowserAgent;