"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configure = configure;
var _api = require("../api/api");
var _nreum = require("../../common/window/nreum");
var _config = require("../../common/config/config");
var _featureFlags = require("../../common/util/feature-flags");
var _runtime = require("../../common/constants/runtime");
var _publicPath = require("./public-path");
let alreadySetOnce = false; // the configure() function can run multiple times in agent lifecycle

/**
 * Sets or re-sets the agent's configuration values from global settings. This also attach those as properties to the agent instance.
 */
function configure(agent) {
  let opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  let loaderType = arguments.length > 2 ? arguments[2] : undefined;
  let forceDrain = arguments.length > 3 ? arguments[3] : undefined;
  // eslint-disable-next-line camelcase
  let {
    init,
    info,
    loader_config,
    runtime = {
      loaderType
    },
    exposed = true
  } = opts;
  const nr = (0, _nreum.gosCDN)();
  if (!info) {
    init = nr.init;
    info = nr.info;
    // eslint-disable-next-line camelcase
    loader_config = nr.loader_config;
  }
  (0, _config.setConfiguration)(agent.agentIdentifier, init || {});
  // eslint-disable-next-line camelcase
  (0, _config.setLoaderConfig)(agent.agentIdentifier, loader_config || {});
  info.jsAttributes ??= {};
  if (_runtime.isWorkerScope) {
    // add a default attr to all worker payloads
    info.jsAttributes.isWorker = true;
  }
  (0, _config.setInfo)(agent.agentIdentifier, info);
  const updatedInit = (0, _config.getConfiguration)(agent.agentIdentifier);
  const internalTrafficList = [info.beacon, info.errorBeacon];
  if (!alreadySetOnce) {
    if (updatedInit.proxy.assets) {
      (0, _publicPath.redefinePublicPath)(updatedInit.proxy.assets);
      internalTrafficList.push(updatedInit.proxy.assets);
    }
    if (updatedInit.proxy.beacon) internalTrafficList.push(updatedInit.proxy.beacon);
    (0, _api.setTopLevelCallers)(); // no need to set global APIs on newrelic obj more than once
    (0, _nreum.addToNREUM)('activatedFeatures', _featureFlags.activatedFeatures);

    // Update if soft_navigations is allowed to run AND part of this agent build, used to override old spa functions.
    agent.runSoftNavOverSpa &&= updatedInit.soft_navigations.enabled === true && updatedInit.feature_flags.includes('soft_nav');
  }
  runtime.denyList = [...(updatedInit.ajax.deny_list || []), ...(updatedInit.ajax.block_internal ? internalTrafficList : [])];
  (0, _config.setRuntime)(agent.agentIdentifier, runtime);
  if (agent.api === undefined) agent.api = (0, _api.setAPI)(agent.agentIdentifier, forceDrain, agent.runSoftNavOverSpa);
  if (agent.exposed === undefined) agent.exposed = exposed;
  alreadySetOnce = true;
}