"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnabledFeatures = getEnabledFeatures;
var _features = require("./features");
var _config = require("../../common/config/config");
const featureNames = Object.values(_features.FEATURE_NAMES);
function isEnabled(name, agentIdentifier) {
  return (0, _config.getConfigurationValue)(agentIdentifier, "".concat(name, ".enabled")) === true;
}
function getEnabledFeatures(agentIdentifier) {
  const enabledFeatures = {};
  featureNames.forEach(featureName => {
    enabledFeatures[featureName] = isEnabled(featureName, agentIdentifier);
  });
  return enabledFeatures;
}