import { FeatureBase } from './feature-base';
import { getInfo, isConfigured, getRuntime } from '../../common/config/config';
import { configure } from '../../loaders/configure/configure';
import { gosCDN } from '../../common/window/nreum';
import { drain } from '../../common/drain/drain';
import { activatedFeatures } from '../../common/util/feature-flags';
export class AggregateBase extends FeatureBase {
  constructor() {
    super(...arguments);
    this.checkConfiguration();
  }

  /**
   * New handler for waiting for multiple flags. Useful when expecting multiple flags simultaneously (ex. stn vs sr)
   * @param {string[]} flagNames
   * @returns {Promise}
   */
  waitForFlags() {
    let flagNames = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    return new Promise((resolve, reject) => {
      if (activatedFeatures[this.agentIdentifier]) {
        resolve(buildOutput(activatedFeatures[this.agentIdentifier]));
      } else {
        this.ee.on('rumresp', function () {
          let resp = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
          resolve(buildOutput(resp));
        });
      }
      function buildOutput(ref) {
        return flagNames.map(flag => {
          if (!ref[flag]) return 0;
          return ref[flag];
        });
      }
    });
  }
  drain() {
    drain(this.agentIdentifier, this.featureName);
  }

  /**
   * Checks for additional `jsAttributes` items to support backward compatibility with implementations of the agent where
   * loader configurations may appear after the loader code is executed.
   */
  checkConfiguration() {
    // NOTE: This check has to happen at aggregator load time
    if (!isConfigured(this.agentIdentifier)) {
      let jsAttributes = {
        ...gosCDN().info?.jsAttributes
      };
      try {
        jsAttributes = {
          ...jsAttributes,
          ...getInfo(this.agentIdentifier)?.jsAttributes
        };
      } catch (err) {
        // do nothing
      }
      configure({
        agentIdentifier: this.agentIdentifier
      }, {
        ...gosCDN(),
        info: {
          ...gosCDN().info,
          jsAttributes
        },
        runtime: getRuntime(this.agentIdentifier)
      });
    }
  }
}