/**
 * @file Contains constants about the environment the agent is running
 * within. These values are derived at the time the agent is first loaded.
 * @copyright 2023 New Relic Corporation. All rights reserved.
 * @license Apache-2.0
 */
/**
 * Indicates if the agent is running within a normal browser window context.
 */
export const isBrowserScope: boolean;
/**
 * Indicates if the agent is running within a worker context.
 */
export const isWorkerScope: boolean;
export const globalScope: false | typeof globalThis;
export const loadedAsDeferredBrowserScript: boolean;
export const initiallyHidden: boolean;
export const initialLocation: string;
export const isiOS: boolean;
/**
 * Shared Web Workers introduced in iOS 16.0+ and n/a in 15.6-
 *
 * It was discovered in Safari 14 (https://bugs.webkit.org/show_bug.cgi?id=225305) that the buffered flag in PerformanceObserver
 * did not work. This affects our onFCP metric in particular since web-vitals uses that flag to retrieve paint timing entries.
 * This was fixed in v16+.
 */
export const iOSBelow16: boolean;
export const ffVersion: number;
export const isIE: boolean;
export const supportsSendBeacon: boolean;
export const offset: number;
//# sourceMappingURL=runtime.d.ts.map