/**
 * Adds an entry to the centralized drain registry specifying that a particular agent has events of a particular named
 * event-group "bucket" that should be drained at the time the agent drains all its buffered events. Buffered events
 * accumulate because instrumentation begins as soon as possible, before the agent has finished lazy-loading the code
 * responsible for aggregating and reporting captured data.
 * @param {string} agentIdentifier - A 16 character string uniquely identifying the agent.
 * @param {string} group - The named "bucket" for the events this feature will be bucketing for later collection.
 */
export function registerDrain(agentIdentifier: string, group: string): void;
/**
 * Removes an item from the registry and immediately re-checks if the registry is ready to "drain all"
 * @param {*} agentIdentifier - A 16 character string uniquely identifying the agent.
 * @param {*} group - The named "bucket" to be removed from the registry
 */
export function deregisterDrain(agentIdentifier: any, group: any): void;
/**
 * Drain buffered events out of the event emitter. Each feature should have its events bucketed by "group" and drain
 * its own named group explicitly, when ready.
 * @param {string} agentIdentifier - A unique 16 character ID corresponding to an instantiated agent.
 * @param {string} featureName - A named group into which the feature's buffered events are bucketed.
 * @param {boolean} force - Whether to force the drain to occur immediately, bypassing the registry and staging logic.
 */
export function drain(agentIdentifier?: string, featureName?: string, force?: boolean): void;
//# sourceMappingURL=drain.d.ts.map