/**
 * Periodically invokes harvest calls and handles retries
 */
export class HarvestScheduler extends SharedContext {
    /**
       * Create a HarvestScheduler
       * @param {string} endpoint - The base BAM endpoint name -- ex. 'events'
       * @param {object} opts - The options used to configure the HarvestScheduler
       * @param {Function} opts.onFinished - The callback to be fired when a harvest has finished
       * @param {Function} opts.getPayload - A callback which can be triggered to return a payload for harvesting
       * @param {number} opts.retryDelay - The number of seconds to wait before retrying after a network failure
       * @param {boolean} opts.raw - Use a prefabricated payload shape as the harvest payload without the need for formatting
       * @param {string} opts.customUrl - A custom url that falls outside of the shape of the standard BAM harvester url pattern.  Will use directly instead of concatenating various pieces
       * @param {*} parent - The parent object, whose state can be passed into SharedContext
       */
    constructor(endpoint: string, opts: {
        onFinished: Function;
        getPayload: Function;
        retryDelay: number;
        raw: boolean;
        customUrl: string;
    }, parent: any);
    endpoint: string;
    opts: {
        onFinished: Function;
        getPayload: Function;
        retryDelay: number;
        raw: boolean;
        customUrl: string;
    };
    started: boolean;
    timeoutHandle: any;
    aborted: boolean;
    harvest: Harvest;
    /**
     * This function is only meant for the last outgoing harvest cycle of a page. It trickles down to using sendBeacon, which should not be used
     * to send payloads while the page is still active, due to limitations on how much data can be buffered in the API at any one time.
     */
    unload(): void;
    startTimer(interval: any, initialDelay: any): void;
    interval: any;
    stopTimer(permanently?: boolean): void;
    scheduleHarvest(delay: any, opts: any): void;
    runHarvest(opts: any): false | undefined;
    onHarvestFinished(opts: any, result: any): void;
}
import { SharedContext } from '../context/shared-context';
import { Harvest } from './harvest';
//# sourceMappingURL=harvest-scheduler.d.ts.map