/**
 * @typedef {import('./types.js').NetworkSendSpec} NetworkSendSpec
 * @typedef {import('./types.js').HarvestEndpointIdentifier} HarvestEndpointIdentifier
 * @typedef {import('./types.js').HarvestPayload} HarvestPayload
 * @typedef {import('./types.js').FeatureHarvestCallback} FeatureHarvestCallback
 * @typedef {import('./types.js').FeatureHarvestCallbackOptions} FeatureHarvestCallbackOptions
 */
export class Harvest extends SharedContext {
    tooManyRequestsDelay: any;
    obfuscator: Obfuscator;
    _events: {};
    /**
     * Initiate a harvest from multiple sources. An event that corresponds to the endpoint
     * name is emitted, which gives any listeners the opportunity to provide payload data.
     * Note: Used by page_action
     * @param {NetworkSendSpec} spec Specification for sending data
     */
    sendX(spec?: NetworkSendSpec): boolean;
    /**
     * Initiate a harvest call.
     * @param {NetworkSendSpec} spec Specification for sending data
     */
    send(spec?: NetworkSendSpec): boolean;
    /**
     * Apply obfuscation rules to the payload and then initial the harvest network call.
     * @param {NetworkSendSpec} spec Specification for sending data
     */
    obfuscateAndSend(spec?: NetworkSendSpec): boolean;
    /**
     * Initiate a harvest call. Typically used by `sendX` and `send` methods or called directly
     * for raw network calls.
     * @param {NetworkSendSpec} param0 Specification for sending data
     * @returns {boolean} True if the network call succeeded. For final harvest calls, the return
     * value should not be relied upon because network calls will be made asynchronously.
     */
    _send({ endpoint, payload, opts, submitMethod, cbFinished, customUrl, raw, includeBaseParams }: NetworkSendSpec): boolean;
    baseQueryString(qs: any): string;
    /**
     * Calls and accumulates data from registered harvesting functions based on
     * the endpoint being harvested.
     * @param {HarvestEndpointIdentifier} endpoint BAM endpoint identifier.
     * @param {FeatureHarvestCallbackOptions} options Options to be passed to the
     * feature harvest listener callback.
     * @returns {HarvestPayload} Payload object to transmit to the bam endpoint.
     */
    createPayload(endpoint: HarvestEndpointIdentifier, options: FeatureHarvestCallbackOptions): HarvestPayload;
    /**
     * Cleans and returns a payload object containing a body and qs
     * object with key/value pairs. KV pairs where the value is null,
     * undefined, or an empty string are removed to save on transmission
     * size.
     * @param {HarvestPayload} payload Payload to be sent to the endpoint.
     * @returns {HarvestPayload} Cleaned payload payload to be sent to the endpoint.
     */
    cleanPayload(payload?: HarvestPayload): HarvestPayload;
    /**
     * Registers a function to be called when harvesting is triggered for a specific
     * endpoint.
     * @param {HarvestEndpointIdentifier} endpoint
     * @param {FeatureHarvestCallback} listener
     */
    on(endpoint: HarvestEndpointIdentifier, listener: FeatureHarvestCallback): void;
}
export type NetworkSendSpec = import('./types.js').NetworkSendSpec;
export type HarvestEndpointIdentifier = import('./types.js').HarvestEndpointIdentifier;
export type HarvestPayload = import('./types.js').HarvestPayload;
export type FeatureHarvestCallback = import('./types.js').FeatureHarvestCallback;
export type FeatureHarvestCallbackOptions = import('./types.js').FeatureHarvestCallbackOptions;
import { SharedContext } from '../context/shared-context';
import { Obfuscator } from '../util/obfuscate';
//# sourceMappingURL=harvest.d.ts.map