/**
 * Tags a specified object with an identifier if it does not already
 * have one. If the object is the global scope, zero will be returned
 * and the object will not be modified. If the object already contains
 * an identifier, it will be returned without modification. If the passed
 * value is not an object, function, or array, -1 will be returned without
 * modifying the passed value.
 * @param {object|function|array} obj Object to be tagged with an identifier
 * @returns {number} Identifier of the given object
 */
export function id(obj: object | Function | array): number;
//# sourceMappingURL=id.d.ts.map