/**
 * Generates a RFC compliant UUIDv4 using native browser crypto engine. If the browser
 * does not support the crypto engine, the function will fallback to insecure Math.random()
 * @returns {string} uuid version 4 string
 */
export function generateUuid(): string;
/**
 * Generates a string of the given length containing only hexadecimal
 * value 0-9 and a-f.
 * @param {int} length length of the string to generate
 * @returns {string} generated hex string
 */
export function generateRandomHexString(length: int): string;
/**
 * Generates a 16 character length hexadecimal string.
 * per DT-spec.
 * @see generateRandomHexString
 * @returns {string} generated hex string
 */
export function generateSpanId(): string;
/**
 * Generates a 32 character length hexadecimal string.
 * per DT-spec.
 * @see generateRandomHexString
 * @returns {string} generated hex string
 */
export function generateTraceId(): string;
//# sourceMappingURL=unique-id.d.ts.map