export class SessionEntity {
    /**
     * Create a self-managing Session Entity. This entity is scoped to the agent identifier which triggered it, allowing for multiple simultaneous session objects to exist.
     * There is one "namespace" an agent can store data in LS -- NRBA_{key}. If there are two agents on one page, and they both use the same key, they could overwrite each other since they would both use the same namespace in LS by default.
     * The value can be overridden in the constructor, but will default to a unique 16 character hex string
     * expiresMs and inactiveMs are used to "expire" the session, but can be overridden in the constructor. Pass 0 to disable expiration timers.
     */
    constructor(opts: any);
    agentIdentifier: any;
    storage: any;
    state: {};
    key: any;
    ee: any;
    setup({ value, expiresMs, inactiveMs }: {
        value?: string | undefined;
        expiresMs?: number | undefined;
        inactiveMs?: number | undefined;
    }): void;
    expiresMs: number | undefined;
    inactiveMs: number | undefined;
    expiresTimer: Timer | undefined;
    inactiveTimer: InteractionTimer | undefined;
    initialized: boolean | undefined;
    get lookupKey(): string;
    sync(data: any): void;
    /**
     * Fetch the stored values from the storage API tied to this entity
     * @returns {Object}
     */
    read(): Object;
    /**
     * Store data to the storage API tied to this entity
     * To preseve existing attributes, the output of ...session.read()
     * should be appended to the data argument
     * @param {Object} data
     * @returns {Object}
     */
    write(data: Object): Object;
    reset(): Object;
    /**
     * Refresh the inactivity timer data
     */
    refresh(): void;
    /**
     * @param {number} timestamp
     * @returns {boolean}
     */
    isExpired(timestamp: number): boolean;
    /**
     * @param {Object} data
     * @returns {boolean}
     */
    isInvalid(data: Object): boolean;
    collectSM(type: any, data: any, useUpdatedAt: any): void;
    getDuration(data: {} | undefined, useUpdatedAt: any): number;
    /**
     * @param {number} futureMs - The number of ms to use to generate a future timestamp
     * @returns {number}
     */
    getFutureTimestamp(futureMs: number): number;
    syncCustomAttribute(key: any, value: any): void;
    custom: any;
}
import { Timer } from '../timer/timer';
import { InteractionTimer } from '../timer/interaction-timer';
//# sourceMappingURL=session-entity.d.ts.map