/**
 * Class used to adjust the timestamp of harvested data to New Relic server time. This
 * is done by tracking the performance timings of the RUM call and applying a calculation
 * to the harvested data event offset time.
 */
export class TimeKeeper {
    static getTimeKeeperByAgentIdentifier(agentIdentifier: any): any;
    constructor(agent: any);
    get correctedPageOriginTime(): number;
    /**
     * Process a rum request to calculate NR server time.
     * @param rumRequest {XMLHttpRequest} The xhr for the rum request
     * @param startTime {number} The start time of the RUM request
     * @param endTime {number} The end time of the RUM request
     */
    processRumRequest(rumRequest: XMLHttpRequest, startTime: number, endTime: number): void;
    /**
     * Converts a page origin relative time to an absolute timestamp
     * corrected to NR server time.
     * @param relativeTime {number} The relative time of the event in milliseconds
     * @returns {number} The correct timestamp as a unix/epoch timestamp value
     */
    convertRelativeTimestamp(relativeTime: number): number;
    /**
     * Corrects an event timestamp to NR server time.
     * @param timestamp {number} The unix/epoch timestamp of the event with milliseconds
     * @return {number} Corrected unix/epoch timestamp
     */
    correctAbsoluteTimestamp(timestamp: number): number;
    /**
     * Returns the current time offset from page origin.
     * @return {number}
     */
    now(): number;
    #private;
}
//# sourceMappingURL=time-keeper.d.ts.map