/**
 * @typedef {xhr|beacon} NetworkMethods
 */
/**
 * Determines the submit method to use based on options.
 * @param {object} opts Options used to determine submit method.
 * @param {boolean} opts.isFinalHarvest Indicates if the data submission is due to
 * a final harvest within the agent.
 */
export function getSubmitMethod({ isFinalHarvest }?: {
    isFinalHarvest: boolean;
}): typeof xhr | typeof beacon;
/**
 * Send via XHR
 * @param {Object} args - The args.
 * @param {string} args.url - The URL to send to.
 * @param {string=} args.body - The Stringified body. Default null to prevent IE11 from breaking.
 * @param {boolean=} args.sync - Run XHR synchronously.
 * @param {string=} [args.method=POST] - The XHR method to use.
 * @param {{key: string, value: string}[]} [args.headers] - The headers to attach.
 * @returns {XMLHttpRequest}
 */
export function xhr({ url, body, sync, method, headers }: {
    url: string;
    body?: string | undefined;
    sync?: boolean | undefined;
    method?: string | undefined;
    headers?: {
        key: string;
        value: string;
    }[] | undefined;
}): XMLHttpRequest;
/**
 * Send via sendBeacon. Do NOT call this function outside of a guaranteed web window environment.
 * @param {Object} args - The args
 * @param {string} args.url - The URL to send to
 * @param {string=} args.body - The Stringified body
 * @returns {boolean}
 */
export function beacon({ url, body }: {
    url: string;
    body?: string | undefined;
}): boolean;
export type NetworkMethods = typeof xhr | typeof beacon;
//# sourceMappingURL=submit-data.d.ts.map