/**
 * Applies a function to properties of a specified type in an object, recursively.
 *
 * @param {Object} obj - The object to apply the function to.
 * @param {Function} fn - The function to apply to matching properties.
 * @param {string} [type='string'] - The type of properties to apply the function to.
 * @param {Array<string>} [ignoreKeys=[]] - The keys of properties to ignore and not modify.
 * @returns {Object} - The object with function recursively applied.
 */
export function applyFnToProps(obj: Object, fn: Function, type?: string | undefined, ignoreKeys?: string[] | undefined): Object;
//# sourceMappingURL=traverse.d.ts.map